/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_14;

import lotus.domino.*; import djbuch.kapitel_06.*;
/**
 * @author Thomas Ekert
 * 
 */
public class RecycleCases implements Runnable {

	private static final String PASSWORD = "geheim";
	private static final String HOST = null; //"www.djbuch.de:63148"; 	//null fr lokale Session
	private static final String USER = null; // "Thomas Ekert/DJBUCH";	//null fr lokale Session
	
	public static void main(String[] args) {
		RecycleCases RecycleCases = new RecycleCases ();
		NotesThread nt = new NotesThread (RecycleCases);
		nt.start();
	}
	
	public void run () {
		Session session = null;
		Database db = null;
		Database otherDb =null;
		DocumentCollection dc=null;
		Document doc = null;
		DbDirectory dbdir = null;
		try {
			session=NotesFactory.createSession (HOST, USER, PASSWORD);
			/** Alternative A - OpenByReplicaID **/
			//die ReplikID C12570400064011C wurde zuvor durch ein db.getReplicaID() ermittelt
			dbdir= session.getDbDirectory(null);
			db = dbdir.openDatabaseByReplicaID("C12570400064011C");
			otherDb = dbdir.openDatabaseByReplicaID("C12570400064011C");
			/** Alternative B - getDatabase 
			 * - wird eine NotesException im System.out.println zur Folge haben.**/
			//db = session.getDatabase(session.getServerName(),"djbuch/djbuch.nsf");
			//otherDb = session.getDatabase(session.getServerName(),"djbuch/djbuch.nsf");
			GC.recycle(db);	//recycled normalerweise auch otherDb, aber nicht bei openDatabaseByReplicaID
			dc = otherDb.getAllDocuments();
			doc = dc.getFirstDocument();
			System.out.println("Dokument " + doc.getUniversalID() + " erfolgreich geladen.");

//			long l = System.currentTimeMillis();
//			DocumentCollection docCollection = null;
//			Document thisDoc = null, nextDoc = null;
//			int count = 1, size=0;
//			try {
//				docCollection = otherDb.getAllDocuments();
//				size= docCollection.getCount();
//				thisDoc = docCollection.getFirstDocument();
//				while (thisDoc != null) {
//					System.out.println("Dokument " + count++ + " / " + size
//							+ ":\t" + thisDoc.getUniversalID());
//					nextDoc = docCollection.getNextDocument();
//					GC.recycle(thisDoc);
//					thisDoc = nextDoc;
//				}
//			} finally {
//				GC.recycle (thisDoc); GC.recycle (nextDoc); GC.recycle(docCollection);
//			}
//			System.out.println ((System.currentTimeMillis()-l));
		} catch (NotesException e) {
			System.out.println ("id = " + (e instanceof NotesException?""+((NotesException)e).id:""));
			e.printStackTrace();
		} finally {
			GC.recycle(doc);
			GC.recycle(dc);
			GC.recycle(db);
			GC.recycle(otherDb);
			GC.recycle (dbdir);
			GC.recycle(session);
		}	
	}
}
